<?php

defined('PF_VERSION') OR exit('Access denied');

class Pf_Posts_Shortcode extends Pf_Base_Post_Shortcode
{

    public function __construct($attrs = array(), $content = '')
    {
        parent::__construct($attrs, $content);
        $this->setting->set_name('pf_post');
    }

    /**
     * Display all post
     */
    public function posts_main()
    {
        if (count($this->attrs) == 0) {
            return '<p>' . __('No post') . '</p>';
        }
        if (($title = $this->get_attr('title'))) {
            $this->conditions .= ' and post_title like ? ';
            $this->param[] = '%' . $title . '%';
        } else {
            $this->get_value_attr_base();
        }
        $this->get_order_attr();
        $result = $this->get_pagination_attr();
        $posts = $this->base_select->select($this->select_columns)->conditions($this->conditions)
                        ->param($this->param)->get();
        if (count($posts)) {
            $result['data'] = $this->get_comment_tag($posts);
        }
        return $this->view->render('post', array('posts' => $this->get_content($result)));
    }

    private function get_comment_tag($data)
    {
        $post_id = get_all_id_object($data);
        $comment = array();
        $tag = array();
        $rating = '';
        if ($this->get_attr('display_comment') != 'false' && get_configuration('enable', 'pf_comment') && get_configuration('enable_comment', 'pf_post')) {
            $comment = $this->get_comments($post_id);
        }
        if ($this->get_attr('display_tag') != 'false') {
            $tag = $this->get_tag_post($post_id, $this->setting->get_value('page_lists'));
        }
        foreach ($data as $key => $item) {
            if ($this->get_attr('display_rating') != 'false' && get_configuration('enable_rating', 'pf_post') == 1 && get_configuration('enable', 'pf_rating') == 1) {
                $rating = Pf::shortcode()->exec('{pf:rating key=post_' . $item->id . ' read_only = true}');
            }
            $item->tags = !empty($tag[$item->id]) ? implode(' ', $tag[$item->id]) : '';
            $item->comments = !empty($comment[$item->id]) ? $comment[$item->id] : '';
            $item->link_detail = public_url($this->setting->get_value('page_detail') . '/id:' . $item->id, false);
            $item->rating = $rating;
            $data[$key] = $item;
        }
        return $data;
    }

}
